--________________________________________________________--
-- FlyWithLua AddOn-Script for Fly the World, ftw-sim.de
--________________________________________________________--
--History:
--
--Version 1.0 2019-01-11 Teddii
--	release
--
--Version 1.1 2019-02-05 Teddii
--	warning is now triggered when running more than 10kts
--
--Version 2.0 2019-08-04 Teddii
--	reworked the script to work with the yaacars.lua file
--
--________________________________________________________--

--position of the interface
local XMin=50
local YMin=770
local yaacarsPath="C:/Users/mk/Documents/YAACARS";

YAACARS = {}
YAACARS['tracking']=0
YAACARS['plane_name']="none"
YAACARS['fuel_kg']=0
YAACARS['payload_kg']=0

--________________________________________________________--
--________________________________________________________--
--________________________________________________________--

dr_tank_ratio = dataref_table("sim/aircraft/overflow/acf_tank_rat")
dr_tank_kg = dataref_table("sim/flightmodel/weight/m_fuel")
dataref("dr_payload", "sim/flightmodel/weight/m_fixed", "writable")

--________________________________________________________--

--set to "deactivate" if you want to see the interface only when hovering the mouse over it
--add_macro("Always show YAACARS-Interface when on ground", "gAlwaysShowYaacarsInterfaceOnGround=true", "gAlwaysShowYaacarsInterfaceOnGround=false",
--			"activate")

function eventTakeOffWithoutYaacarsFlightStarted()
	XPLMSpeakString("YAACARS tracking not started!")
	--command_once("sim/operation/pause_toggle")
end
--________________________________________________________--
--________________________________________________________--
--________________________________________________________--
--________________________________________________________--
--________________________________________________________--
--________________________________________________________--
--________________________________________________________--
--________________________________________________________--
--________________________________________________________--

require "graphics"
--________________________________________________________--

dataref("datRAlt", 			"sim/cockpit2/gauges/indicators/radio_altimeter_height_ft_pilot")
dataref("datGSpd", 			"sim/flightmodel/position/groundspeed")

--________________________________________________________--

local XMax=XMin+130
local YMax=YMin+80

local StartButtonTimer=os.clock()

--________________________________________________________--

do_often("yaacars_interface_check_often()")
do_every_draw("yaacars_interface_info()")
do_on_mouse_click("yaacars_interface_events()")
--________________________________________________________--

local flightNotStarted=0
function yaacars_interface_check_often()
	dofile(yaacarsPath.."/yaacars.lua") 	-- import the yaacars data table

	GS=math.floor(datGSpd*1.94384449) --datGSpd is m/s (not kts)

	--if(datRAlt>25 and datGSpd>25)
	if(GS>10)
	then
		if(flightNotStarted<10) then --count from 0 to 3
			flightNotStarted=flightNotStarted+1
		end
		if(flightNotStarted==2 or flightNotStarted==5 or flightNotStarted==8) then --trigger event three times
			if (YAACARS['tracking']==0) then
				eventTakeOffWithoutYaacarsFlightStarted()
			end
		end
	end
	if(GS<5) then
		flightNotStarted=0
	end
end

local showInterface
function yaacars_interface_info()

	showInterface=false
	-- does we have to draw anything?
	if MOUSE_X > XMin and MOUSE_X < XMax and MOUSE_Y > YMin and MOUSE_Y < YMax then
		showInterface=true
	end
	--if(datRAlt<10 and datGSpd<5) then
	--	showInterface=true
	--end
	if(YAACARS['tracking']==0) then
		showInterface=true
	end

	if(showInterface==false) then
		return
	end
	
	-- init the graphics system
	XPLMSetGraphicsState(0,0,0,1,1,0,0)

	-- draw transparent backgroud
	graphics.set_color(0, 0, 0, 0.5)
	graphics.draw_rectangle(XMin, YMin, XMax, YMax)

	--if(datOnGround~=0) then
	--	draw_string_Helvetica_10(XMin+5, YMin+85, "Plane is ON GROUND!")
	--end
	
	-- draw lines around the hole block
	if(YAACARS['tracking']==0) then
		graphics.set_color(1, 0, 0, 0.5) 	 --red
	else 
		graphics.set_color(0, 1, 0, 0.5)	 --green
	end

	graphics.set_width(2)
	graphics.draw_line(XMin, YMin, XMin, YMax)
	graphics.draw_line(XMin, YMax, XMax, YMax)
	graphics.draw_line(XMax, YMax, XMax, YMin)
	graphics.draw_line(XMax, YMin, XMin, YMin)

	graphics.draw_line(XMin, 	YMin+30, XMax-1,  YMin+30) 	--hor
	graphics.draw_line(XMin+35, YMin+1,  XMin+35, YMin+30)	--vert1
	graphics.draw_line(XMin+40, YMin+1,  XMin+40, YMin+30)	--vert2
	graphics.draw_line(XMin+86, YMin+1,  XMin+86, YMin+30)	--vert3

	graphics.set_color(1, 1, 1, 0.8)

	if(YAACARS['tracking']==0) then
		draw_string_Helvetica_10(XMin+5, YMin+67,     "Status                     idle")
	else
		draw_string_Helvetica_10(XMin+5, YMin+67,     "Status   TRACKING flight")
	end
	
	if(YAACARS['tracking']==0) then
		str=string.format("Fuel (kg)                %6i",math.floor(YAACARS['fuel_kg']))
		if(YAACARS['fuel_kg']~=0) then
			draw_string_Helvetica_10(XMin+5, YMin+52, str)
		end
		str=string.format("Payload (kg)          %6i",math.floor(YAACARS['payload_kg']))
		if(YAACARS['payload_kg']~=0) then
			draw_string_Helvetica_10(XMin+5, YMin+37, str)
		end
	end
	
	if(YAACARS['tracking']==0) then
		if(YAACARS['fuel_kg']~=0) then
			draw_string_Helvetica_10(XMin+44, YMin+17, "Load")
			draw_string_Helvetica_10(XMin+44, YMin+5,  "Fuel")
		end
		if(YAACARS['payload_kg']~=0) then
			draw_string_Helvetica_10(XMin+91, YMin+17, "Load")
			draw_string_Helvetica_10(XMin+91, YMin+5,  "Payload")
		end
	end
end
--________________________________________________________--

function yaacars_interface_events()
	-- we will only react once
	if MOUSE_STATUS ~= "down" then
		return
	end
	
	--if MOUSE_X > XMin and MOUSE_X < XMin+36 and MOUSE_Y > YMin and MOUSE_Y < YMin+31 then
	--	RESUME_MOUSE_CLICK = false
	--end
	if MOUSE_X > XMin+50 and MOUSE_X < XMin+70 and MOUSE_Y > YMin+5 and MOUSE_Y < YMin+25 then
		if(YAACARS['tracking']==0 and YAACARS['fuel_kg']~=0) then
			for tankID = 0, 8 do
				dr_tank_kg[tankID]=dr_tank_ratio[tankID]*YAACARS['fuel_kg']
			end
		end
		RESUME_MOUSE_CLICK = false
	end
	if MOUSE_X > XMin+90 and MOUSE_X < XMin+120 and MOUSE_Y > YMin+5 and MOUSE_Y < YMin+25 then
		if(YAACARS['tracking']==0 and YAACARS['payload_kg']~=0) then
			dr_payload=YAACARS['payload_kg']
		end
		RESUME_MOUSE_CLICK = false
	end
	--if MOUSE_X > XMin+5 and MOUSE_X < XMax-5 and MOUSE_Y > YMin+35 and MOUSE_Y < YMax-5 then
	--	--command_once("fse/window/toggle")
	--	RESUME_MOUSE_CLICK = false
	--end
end
--________________________________________________________--
